//=============================================================================
// Price Check Button, for when you can't go shopping all willy-nilly!
//=============================================================================
class PriceCheckButton extends DeusExDecoration;

#exec TEXTURE IMPORT NAME="PriceCheckButton" FILE="C:\DeusEx\MSShopping1_2\Textures\PriceCheckButton.bmp" GROUP=Skins

var() float buttonLitTime;
var() sound buttonSound1;
var() sound buttonSound2;
var() bool bLit;
var() bool bWaitForEvent;
var bool isPressed;

var Vector	lastLoc, rpcLocation;
var bool		bIsMoving;

//new stuff for this class
var() ShopButtonC ShopButton;

replication 
{
	reliable if ( Role == ROLE_Authority )
		rpcLocation;
        /*reliable if ( Role < ROLE_Authority )
                ItemPrice, bInModMode;*/
}

function Trigger(Actor Other, Pawn Instigator)
{
	if (bWaitForEvent)
		Timer();
}

function Timer()
{
	PlaySound(buttonSound2, SLOT_None);
	isPressed = False;
}

function Frob(Actor Frobber, Inventory frobWith)
{
local Actor A;
local Pawn P;
local Credits C;
local int j;
local VaultLocPoint VaultLoc;
local PlacementLocPoint PlacementLoc;
local vector PlacementLocation, RegisterLocation;

  P = Pawn(Frobber);


    if ((ShopButton != None) && (ShopButton.ItemPrice > 0))
     DeusExPlayer(Frobber).ClientMessage("|p3The item |p4"$ShopButton.BoughtItemName$"|p3 costs "$ShopButton.ItemPrice$" Dollars!");
    if ((ShopButton != None) && (ShopButton.ItemPrice <= 0))
     DeusExPlayer(Frobber).ClientMessage("|p3The item "$ShopButton.BoughtItemName$" is free!");
}

singular function SupportActor(Actor standingActor)
{
	// do nothing
}

function Bump(actor Other)
{
	// do nothing
}

simulated function Tick( float deltaTime )
{						  	
	if ( Level.NetMode != NM_Standalone )
	{
		if ( Role == ROLE_Authority )
		{
			// Was moving, now at rest
			if ( bIsMoving && ( Location == lastLoc ))
				rpcLocation = Location;

			bIsMoving = ( Location != lastLoc );
			lastLoc = Location;
		}
		else
		{
			// Our replicated location changed which means the button has come to rest
			if ( lastLoc != rpcLocation )
			{
				SetLocation( rpcLocation );
				lastLoc = rpcLocation;
			}
		}
	}
	Super.Tick( deltaTime );
}

defaultproperties
{
     buttonLitTime=0.500000
     buttonSound1=Sound'DeusExSounds.Generic.Beep1'
     bInvincible=True
     bCollideActors=True
     bBlockActors=True
     bProjTarget=True
     ItemName="|p3Price Check Button"
     bPushable=False
     Physics=PHYS_None
     RemoteRole=ROLE_SimulatedProxy
     Mesh=LodMesh'DeusExDeco.Button1'
     MultiSkins(0)=Texture'PriceCheckButton'
     CollisionRadius=2.000000
     CollisionHeight=2.000000
     bCollideWorld=False
     bBlockActors=False
     Mass=5.000000
     Buoyancy=2.000000
}
